

//used to define the pickerDef at compile time.  May include all of the slots for the pickerDef.
//In the listPicker.pickerDef proto to this DataDef.  

DefConst('kMyHyperLinkSoupDataDef,{
		 _proto: protoNameRefDataDef,		// required
		 validationFrame: nil,				// used if editing will be supported
		 primaryPath: 'title,				// uses the path in an item for the sort order
		 class: '|nameRef.hyperlinks|,
		 name: "HyperLinks",
		 
		Get: func(item, fieldPath, format) begin
			if item then begin
				local entry := if EntryFromObj(item) then EntryFromObj(item) else item;
				local class := ClassOf(entry);
				local dataDef, icon, title;
							
				if class <> 'nameRef then
					dataDef := GetEntryDataDef(entry);
	
				if fieldPath = 'theIcon then begin
					if class = 'nameRef then icon := entry.icon;
					else if dataDef then begin
						if IsFunction(dataDef.IconExtract) then icon := dataDef:IconExtract(entry);
						else if dataDef.overviewIcon then icon := dataDef.overviewIcon;
						else if dataDef.icon then icon := dataDef.icon;
					end;
					
					if not icon then icon := @381;
					
					OffsetShape(MakeShape(Clone(icon)), -2,2);
				end;
				else if fieldPath = 'strTitle then begin
					if class = 'nameRef then title := entry.title;
					else if dataDef and dataDef.StringExtract then title := dataDef:StringExtract(entry, 1);
					
					if title then Clone(title) else "";
				end;
				else inherited:Get(item,fieldPath,format);
			end;
			else inherited:Get(item,fieldPath,format);
		end,
		columns:
			[	{ fieldPath: 'theIcon, tapWidth: 38, doRowHilite: true, },
				{ fieldPath: 'strTitle, tapWidth: -1, doRowHilite: true,},		
			],
});

DefConst('kHyperLinksQuerySpec, 
	{
		type:			'index,
		indexPath:		[[pathExpr: kAppSymbol, 'parentID], 'class],
		indexValidTest:	func(arr) arr[1] = kHLDataSymbol,
	}
);